$NOLIST
	NAME	MiscRamCode

$INCLUDE (``OsIncs`WinASM~Inc~)

RAM_DGROUP GROUP	RAM_DATA
RAM_CGROUP GROUP	RAM_CODE

 PUBLIC    LineHeight, CharWidth
	PUBLIC    BaseLine, CharHeight
	PUBLIC    GetMeWindowState, OsForkProcess

 EXTRN     xOsForkProcess: FAR   ; Go thru system sema first

RAM_DATA	SEGMENT	PUBLIC	'DATA'
RAM_DATA	ENDS

RAM_CODE	SEGMENT	PUBLIC	'CODE'
	ASSUME	CS:RAM_CGROUP

	EXTRN     CpWhoAmI: NEAR
 EXTRN     CpSetActiveSlot: NEAR
 EXTRN     mySlot: BYTE

; FUNCTION GetMeWindowState: SELECTOR;
;
;
pcb STRUC
  whoCares  DB 78 DUP (?)
  windowOff DW ?
  windowSeg DW ?
pcb ENDS

GetMeWindowState PROC NEAR
	CALL      CpWhoAmI
	MOV       ES, AX
	MOV       AX, ES:windowSeg
	RET
GetMeWindowState ENDP

; FUNCTION LineHeight: BYTE;
;
; This routine will return the lineheight of the 
; current font. The lineHeight will be put in AL.

LineHeight PROC FAR
	PUSH	DS
	CALL	GetMeWindowState
	MOV	DS,AX

	LES	BX,DS:wsPFontTable
	XOR	AH,AH
	MOV	AL, BYTE PTR ES:[BX+3] ;LineHeight
	OR        AL, AL
	JNZ       DoneLineHeight 
	MOV	AL, BYTE PTR ES:[BX+2] ;CharHeight
	ADD       AL, 2

DoneLineHeight:
	POP	DS
	RET
LineHeight ENDP


; FUNCTION CharHeight: BYTE;
;
; This routine will return the charheight of the 
; current font. The charHeight will be put in AL.

CharHeight PROC FAR
	PUSH	DS
	CALL	GetMeWindowState
	MOV	DS,AX

	LES	BX,DS:wsPFontTable
	XOR	AH,AH
	MOV	AL, BYTE PTR ES:[BX+2] ;CharHeight

	POP	DS
	RET
CharHeight ENDP
$EJECT

; FUNCTION CharWidth: BYTE;
;
; This routine will return the CharWidth of the 
; current font. The charwidth will be put in AL.

CharWidth PROC FAR
	PUSH	DS
	CALL	GetMeWindowState
	MOV	DS,AX

	LES	BX,DS:wsPFontTable
	XOR	AH,AH
	MOV	AL, BYTE PTR ES:[BX+1] ;CharWidth

	POP	DS
	RET
CharWidth ENDP


; FUNCTION BaseLine: BYTE;
;
; This routine will return the baseline of the 
; current font. The baseline will be put in AL.

BaseLine PROC FAR
	PUSH	DS
	CALL	GetMeWindowState
	MOV	 DS,AX

	LES	 BX,DS:wsPFontTable
	XOR	 AH,AH
	MOV	 AL, BYTE PTR ES:[BX+4] ;BaseLine
	OR   AL, AL
	JNZ  DoneBaseLine
	MOV	 AL, BYTE PTR ES:[BX+2] ;CharHeight
	DEC  AL

DoneBaseLine:
	POP	 DS
	RET
BaseLine  ENDP
$EJECT
$LIST

; PROCEDURE OsForkProcess (entrypoint, priority, uses8087, stacksize, pError);
;   DCL uses8087   BOOLEAN;
;   DCL priority   BYTE;
;   DCL stacksize  WORD;
;   DCL entrypoint PTR;
;   DCL pError     PTR;
;

pError     EQU DWORD PTR [BP+08]
stackSize  EQU  WORD PTR [BP+12]
uses8087   EQU  BYTE PTR [BP+14]
priority   EQU  BYTE PTR [BP+16]
entrypoint EQU DWORD PTR [BP+18]
    
OsForkProcess PROC FAR
  PUSH DS
  PUSH BP
  MOV  BP, SP

  MOV  AX, RAM_DGROUP
  MOV  DS, AX

  MOV  AL, RAM_CGROUP:mySlot
  PUSH AX
  CALL CpSetActiveSlot       ; Swap to InteGRiD's EMS/ROM slot
  PUSH AX                    ; save callers EMS/ROM slot on stack

  PUSH AX                    ; First parm is slot
  LES  AX, entrypoint
  PUSH ES
  PUSH AX
  MOV  AL, priority
  PUSH AX
  MOV  AL, uses8087
  PUSH AX
  PUSH stackSize
  LES  AX, pError
  PUSH ES
  PUSH AX
  CALL xOsForkProcess

  POP  BX                    ; saved EMS/ROM slot

  PUSH AX                    ; Return parameter (procID)
  PUSH BX                    ; EMS/ROM slot to restore
  CALL CpSetActiveSlot       ; Restore callers EMS/ROM slot
  POP  AX                    ; Return parameter (procID)

  POP BP
  POP DS
 	RET 14
OsForkProcess  ENDP

PURGE pError, stacksize, uses8087, priority, entrypoint


RAM_CODE	ENDS

END
